const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('tbl_productsummary_temp', {
    ID: {
      type: DataTypes.INTEGER,
      allowNull: false,
      primaryKey: true,
      autoIncrement: true
    },
    ParamName: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    Param_Min: {
      type: DataTypes.STRING(10),
      allowNull: true,
      defaultValue: "0"
    },
    Param_Max: {
      type: DataTypes.STRING(10),
      allowNull: true,
      defaultValue: "0"
    },
    Param_Avg: {
      type: DataTypes.STRING(10),
      allowNull: true,
      defaultValue: "0"
    },
    Param_Unit: {
      type: DataTypes.STRING(10),
      allowNull: true,
      defaultValue: "NA"
    },
    ProductType: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    ProductId: {
      type: DataTypes.STRING(150),
      allowNull: false,
      defaultValue: "NULL"
    },
    ProductName: {
      type: DataTypes.STRING(300),
      allowNull: true,
      defaultValue: "NULL"
    },
    PrdVersion: {
      type: DataTypes.STRING(200),
      allowNull: true,
      defaultValue: "NULL"
    },
    Version: {
      type: DataTypes.STRING(200),
      allowNull: true,
      defaultValue: "NULL"
    },
    BatchNo: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    BatchSize: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    CubType: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    Remark: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    DP: {
      type: DataTypes.INTEGER,
      allowNull: false,
      defaultValue: 0
    },
    Param_MinDT: {
      type: DataTypes.TIME,
      allowNull: true,
      defaultValue: "00:00:00"
    },
    Param_MaxDT: {
      type: DataTypes.TIME,
      allowNull: true,
      defaultValue: "00:00:00"
    },
    Param_AvgDT: {
      type: DataTypes.TIME,
      allowNull: true,
      defaultValue: "00:00:00"
    },
    HMI_ID: {
      type: DataTypes.STRING(25),
      allowNull: true,
      defaultValue: "0"
    },
    StartDt: {
      type: DataTypes.DATEONLY,
      allowNull: false
    },
    EndDt: {
      type: DataTypes.DATEONLY,
      allowNull: false
    },
    LODValue:{
      type:DataTypes.STRING(50),
      allowNull:true,
      defaultValue:"NULL"
    },
    CubicName: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    MPN_Code: {
      type: DataTypes.STRING(300),
      allowNull: true,
      defaultValue: "NULL"
    }
  }, {
    sequelize,
    tableName: 'tbl_productsummary_temp',
    schema: 'dbo',
    timestamps: false,
    indexes: [
      {
        name: "PK__tbl_productsummary_temp",
        unique: true,
        fields: [
          { name: "ID" },
        ]
      },
    ]
  });
};
